/*! 
    \file world_entity.h
    \brief Definition of the basic WorldEntity
*/

#ifndef _WORLD_ENTITY_H
#define _WORLD_ENTITY_H

#include "p_node.h"
#include "comincl.h"

//class CollisionCluster;
class CharacterAttributes;
class Model;


//! Basic class from which all interactive stuff in the world is derived from
class WorldEntity : public PNode
{	
  friend class World;

 public:
  WorldEntity (bool isFree = false);
  virtual ~WorldEntity ();



  
  //void setCollision (CollisionCluster* newhull);
  
  //void addAbility(Ability* ability);
  //void removeAbility(Ability* ability);
  void setDrawable (bool bDraw);  
  bool isFree ();
  void setCharacterAttributes(CharacterAttributes* charAttr);
  CharacterAttributes* getCharacterAttributes();

  virtual void postSpawn ();
  virtual void leftWorld ();

  virtual void hit (WorldEntity* weapon, Vector* loc);
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void command (Command* cmd);

  void processDraw ();
  virtual void draw ();
  virtual void tick (float time);
  
 protected:
  Model* model;                  //!< The model that should be loaded for this entity.
  CharacterAttributes* charAttr;      //!< the character attributes of a world_entity
  
 private:
  const bool bFree;	              //!< If the entity is free.
  bool bCollide;                      //!< If it should be considered for the collisiontest.
  bool bDraw;                         //!< If it should be visible.



  //CollisionCluster* collisioncluster; //!< The collision-Cluster of this entity.
};

#endif /* _WORLD_ENTITY_H */
