/*! 
    \file resource_manager.h
    \brief The Resource Manager checks if a file/resource is loaded.

    If a file/resource was already loaded the resourceManager will 
    return a void pointer to the desired resource.
    Otherwise it will instruct the coresponding resource-loader to load,
    and receive a pointer to it.
*/

#ifndef _RESOURCE_MANAGER_H
#define _RESOURCE_MANAGER_H

#include "base_object.h"

// FORWARD DEFINITION \\


enum ResourceType {OBJ, WAV, MP3, OGG, IMAGE};

//! The ResourceManager is a class, that decides if a file/resource should be loaded
/**
   If a file/resource was already loaded the resourceManager will 
   return a void pointer to the desired resource.
   Otherwise it will instruct the corresponding resource-loader to load,
   and receive the pointer to it.

   It does it by looking, if a desired file has already been loaded.
*/
class ResourceManager : public BaseObject 
{
 public:
  static ResourceManager* getInstance();
  virtual ~ResourceManager();

  bool setDataDir(char* dataDir);
  static void* load(const char* fileName);
  static void* load(const char* fileName, ResourceType type);

 private:
  ResourceManager();
  static ResourceManager* singletonRef;


  struct file;
  struct folder
  {
    char* name;
    folder** subfolders;             //!< 
    file** files;                    //!< Files in the directory
  };
  struct file
  {
    char* name;                      //!< exact Name of a file
    void* pointer;
  };

  char* dataDir;                     //!< The main data directory

  static bool isDir(const char* directory);
  static bool isFile(const char* directory);  
};

#endif /* _RESOURCE_MANAGER_H */
