/*! 
    \file orxonox.h
    \brief Orxonox core functions
*/ 

#ifndef _ORXONOX_H
#define _ORXONOX_H

#include "comincl.h"
#include "glincl.h"

class CommandNode;
class WorldEntity;
class DataTank;
class World;
class Camera;
class GameLoader;

//! Orxonox core singleton class
/**
*/
class Orxonox {

 private:
  static Orxonox* singletonRef;
  Orxonox ();
  virtual ~Orxonox ();

  char configfilename[256];   //!< Filename of the configuration-file.
  World* world;               //!< Reference to the current running world.
  DataTank* resources;        //!< DataContainer
  CommandNode* localinput;    //!< Command Handler
  SDL_Surface* screen;        //!< The current Screen
  GameLoader* gameLoader;     //!< The gameLoader
  
  bool bQuitOrxonox;          //!< If Orxonox should Quit
  bool pause;                 //!< Pause mode
  Uint32 lastframe;           //!< Time of the last Frame
  
  void getConfigFile (int argc, char** argv);
  
  // main loop functions
  //  void synchronize ();
  //void handle_input ();
  //void time_slice ();
  //void collision ();
  //void display ();
  
  	// subsystem initialization
  int initVideo ();
  int initSound ();
  int initInput ();
  int initNetworking ();
  int initResources ();
  int initWorld ();
  
 public:
  static Orxonox* getInstance ();
  void start();
  void quitGame();

  void eventHandler (SDL_Event* event);
  bool systemCommand (Command* cmd);

  int init (int argc, char** argv);
  
  CommandNode* getLocalInput();
  World* getWorld();
  SDL_Surface* getScreen ();
  
  //void mainLoop();
};

int startHelp(void);
int startOrxonox(int argc, char** argv);
int startBenchmarks(void);

#endif /* _ORXONOX_H */

