/*! 
    \file proto_class.h
    \brief Definition of the proto class template, used quickly start work
    \todo Example: this shows how to use simply add a Marker that here has to be done something.

    The Protoclass exists, to help you quikly getting the run for how to develop in orxonox.
    It is an example for the CODING-CONVENTION, and a starting-point for every class.
*/

#ifndef _GARBAGE_COLLECTOR_H
#define _GARBAGE_COLLECTOR_H

#include "base_object.h"


//! this class maintains the garbage collection.
/**
   the class is been ticked by the world.cc and goes through the 
   world_entity list to clean out all unused entities.
*/
class GarbageCollector : public BaseObject {

 public:
  GarbageCollector();
  virtual ~GarbageCollector();
  static GarbageCollector* getInstance();

  void setCollectionDelay(float delay);

  void forceCollection();

  void tick(float time);
  void update();

 private:
  static GarbageCollector* singletonRef;
  float delay;                                        //!< this is the delay to wait until collection
  float time;                                         //!< the current time

};

#endif /* _GARBAGE_COLLECTOR_H */
