

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD

#include "garbage_collector.h"

#include "world.h"
#include "world_entity.h"
#include "null_parent.h"

#include "list.h"

using namespace std;


GarbageCollector* GarbageCollector::singletonRef = 0;

/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
GarbageCollector::GarbageCollector () 
{
   this->setClassName ("GarbageCollection");
   this->time = 0;
   this->delay = 3.0f; /* clean up all 5.0 seconds */
}


/**
   \brief standard deconstructor

*/
GarbageCollector::~GarbageCollector () 
{
  // delete what has to be deleted here
}


/**
   \brief this returns the singleton reference this this class
   \returns singleton reference
*/
GarbageCollector* GarbageCollector::getInstance()
{
  if( singletonRef == NULL)
    singletonRef = new GarbageCollector();
  return singletonRef;
}


void GarbageCollector::setCollectionDelay(float delay)
{}


void GarbageCollector::forceCollection()
{
  
}

void GarbageCollector::tick(float time)
{
  this->time += time;
}


void GarbageCollector::update()
{
  if( this->time < this->delay)
    return;
  /* garbage collect */
  PRINTF(3)("GarbageCollection is been done\n");
  WorldInterface* wi = WorldInterface::getInstance();
  tList<WorldEntity>* list = wi->getEntityList();
  //WorldEntity* entity = list->enumerate(); 
 // while( entity != NULL) 
  //  { 
  //  if( entity->isFinalized())
  //{
  //  PRINTF(3)("Finalizing object in list - not yet done realy\n");
	  /* first remove out of entity list */
	  //list->remove(entity);
	  /* second remove out of pnode tree */
	  //NullParent* np = NullParent::getInstance();
	  //np->removeChild(np);
	  
  //}
  //   entity = list->nextElement();
  //}
  
  /* reset time to count again up to this->delay */
  this->time = 0;
}
