/*! 
    \projectile.h
    \brief a projectile, that is been shooted by a weapon
*/

#ifndef _PROJECTILE_H
#define _PROJECTILE_H

#include "world_entity.h"

class Primitive;
class Vector;

class Projectile : public WorldEntity 
{
  friend class World;

 public:
  Projectile ();
  virtual ~Projectile ();

  void setFlightDirection(Quaternion* flightDirection);
  void setSpeed(float speed);
  void setTTL(float ttl);

  virtual void hit (WorldEntity* weapon, Vector* loc);
  virtual void destroy ();

  virtual void tick (float time);
  virtual void draw ();

 private:
  //physical attriutes like: force, speed, acceleration etc.
  Primitive* projectileModel;          //!< this serves temporary as a plasma bullet
  float speed;                         //!< this is the speed of the projectile
  float currentLifeTime;               //!< this is the time, the projectile exists in this world (incremented by tick)
  float ttl;                           //!< time to life, after this time, the projectile will garbage collect itself
  Vector* flightDirection;             //!< direction in which the shoot flights
  
};

#endif /* _PROJECTILE_H */
