/*! 
    \file camera.h
    \brief Viewpoint controlling class definitions
*/ 

#ifndef _CAMERA_H
#define _CAMERA_H

#include "p_node.h"

class World;
class CameraTarget;


//! Camera
/**
   This class controls the viewpoint from which the World is rendered.
*/
class Camera : public PNode 
{
 private:
  CameraTarget* target;            //!< The Target of the Camera (where this Camera Looks at)

  float fovy;                      //!< The field of view Angle (in degrees).
  float aspectRatio;               //!< The aspect ratio (width / height).
  float nearClip;                  //!< The near clipping plane.
  float farClip;                   //!< The far clipping plane.
  
 public:
  Camera(void);
  virtual ~Camera(void);

  void lookAt(PNode* target);
  PNode* getTarget();

  void setAspectRatio(float aspectRatio);
  void setFovy(float fovy);
  void setClipRegion(float nearClip, float farClip);

  void apply (void);
};

//! A CameraTarget is where the Camera is looking at.
class CameraTarget : public PNode 
{
  friend class Camera;             //! The CameraTarget is a friend of Camera. noone else needs a CameraTarget, so noone else can create it.
  
 private:
  CameraTarget(void);
  
 public:
  virtual ~CameraTarget(void);
};


#endif /* _CAMERA_H */
