

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

#include "camera.h"

#include "world.h"
#include "world_entity.h"
#include "vector.h"

using namespace std;

////////////
// CAMERA //
////////////

/**
   \brief creates a Camera
*/
Camera::Camera(void)
{
  this->target = new CameraTarget();

  this->setFovy(60);
  this->setAspectRatio(1.2f);
  this->setClipRegion(.1, 2000);
}

/**
   \brief default destructor
*/
Camera::~Camera(void)
{

}

/**
   \brief focuses the Camera onto a Target
   \param target the new PNode the Camera should look at.
*/
void Camera::lookAt(PNode* target)
{
  this->target->setParent(target);
}

PNode* Camera::getTarget(void)
{
  return (PNode*)this->target;
}


/**
   \brief sets a new AspectRatio
   \param aspectRatio the new aspect ratio to set (width / height)
*/
void Camera::setAspectRatio(float aspectRatio)
{
  this->aspectRatio = aspectRatio;
}

/**
   \brief sets the Field of View to fofy
   \param fovy new field of view factor (in degrees)
*/
void Camera::setFovy(float fovy)
{
  this->fovy = fovy;
}

/**
  \brief Sets a new clipping region
  \param nearClip The near clip plane
  \param farClip The far clip plane
*/
void Camera::setClipRegion(float nearClip, float farClip)
{
  this->nearClip = nearClip;
  this->farClip = farClip;
}




/**
   \brief initialize rendering perspective according to this camera
   
   This is called immediately before the rendering cycle starts, it sets all global
   rendering options as well as the GL_PROJECTION matrix according to the camera.
*/
void Camera::apply ()
{
  // switching to Projection Matrix
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();

  // setting up the perspective
  gluPerspective(this->fovy,
		 this->aspectRatio,
		 this->nearClip,
		 this->farClip);

  // speed-up feature
  Vector cameraPosition = this->getAbsCoor();
  Vector targetPosition = this->target->getAbsCoor();

  // Setting the Camera Eye, lookAt and up Vectors
  gluLookAt(cameraPosition.x, cameraPosition.y, cameraPosition.z,
	    targetPosition.x, targetPosition.y, targetPosition.z,
	    0.0, 1.0, 0.0);

  // switching back to Modeling Matrix
  glMatrixMode (GL_MODELVIEW);
}



///////////////////
// CAMERA-TARGET //
///////////////////


CameraTarget::CameraTarget()
{
  
}

CameraTarget::~CameraTarget()
{

}
