/*! 
    \file camera.h
    \brief Viewpoint controlling class definitions
*/ 

#ifndef _CAMERA_H
#define _CAMERA_H

#include "p_node.h"

class World;
class CameraTarget;


//! Camera
/**
   This class controls the viewpoint from which the World is rendered.
*/
class Camera : public PNode 
{
 private:
  CameraTarget* target;
  
 public:
  Camera(void);
  virtual ~Camera(void);

  void lookAt(PNode* target);
  
  PNode* getTarget();
  void apply ();
};

//! A CameraTarget is where the Camera is looking at.
class CameraTarget : public PNode 
{
  friend class Camera; //! 
  
 private:
  CameraTarget(void);
  
 public:
  virtual ~CameraTarget(void);
};


#endif /* _CAMERA_H */
