

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

#include "camera.h"

#include "world.h"
#include "world_entity.h"
#include "vector.h"

using namespace std;

////////////
// CAMERA //
////////////

/**
   \brief creates a Camera
*/
Camera::Camera(void)
{
  this->target = new CameraTarget();
}

/**
   \brief default destructor
*/
Camera::~Camera(void)
{

}

/**
   \brief focuses the Camera onto a Target
   \param target the new PNode the Camera should look at.
*/
void Camera::lookAt(PNode* target)
{
  this->target->setParent(target);
}

PNode* Camera::getTarget(void)
{
  return (PNode*)this->target;
}

/**
   \brief initialize rendering perspective according to this camera
   
   This is called immediately before the rendering cycle starts, it sets all global
   rendering options as well as the GL_PROJECTION matrix according to the camera.
*/
void Camera::apply ()
{
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();

  gluPerspective(60, 1.2f, 0.1, 2000);
  float matrix[4][4];

  Vector cameraPosition = this->getAbsCoor();
  Vector targetPosition = this->target->getAbsCoor();

  gluLookAt(cameraPosition.x, cameraPosition.y, cameraPosition.z,
	    targetPosition.x, targetPosition.y, targetPosition.z,
	    0.0, 1.0, 0.0);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
}



///////////////////
// CAMERA-TARGET //
///////////////////


CameraTarget::CameraTarget()
{
  
}

CameraTarget::~CameraTarget()
{

}
