

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "projectile.h"

#include "world_entity.h"
#include "objModel.h"
#include "primitive.h"
#include "vector.h"

using namespace std;


/**
   \brief standard constructor
*/
Projectile::Projectile () : WorldEntity()
{
  //this->model = new OBJModel("");
  this->projectileModel = new Primitive(P_SPHERE);
}


/**
   \brief standard deconstructor
*/
Projectile::~Projectile () 
{
  /* 
     do not delete the test projectModel, since it is pnode 
     and will be cleaned out by world 
  */
  //delete this->projectileModel;
}


/**
   \brief signal tick, time dependent things will be handled here
   \param time since last tick
*/
void Projectile::tick (float time) 
{}

/**
   \brief the projectile gets hit by another entity
   \param the other entity
   \param place where it is hit
*/
void Projectile::hit (WorldEntity* entity, Vector* place) 
{}


/**
   \brief the function gets called, when the projectile is destroyed
*/
void Projectile::destroy () 
{}


void Projectile::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);  
  //this->model->draw();
  PRINTF(1)("draw draw draw draw draw draw \n");
  this->projectileModel->draw();

  glPopMatrix();
}

