

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "story_entity.h"


using namespace std;



StoryEntity::StoryEntity () {}
StoryEntity::~StoryEntity () {}


/** 
    \brief sets the story ID

    sets the story id of the current entity, this enables it to be identified in a 
    global context.
*/
void StoryEntity::setStoryID(int storyID)
{
  this->storyID = storyID;
}


/** 
    \brief this reads the story id of the current entity
    \returns the story entity id
*/
int StoryEntity::getStoryID()
{
  return this->storyID;
}


/** 
    \brief sets the id of the next story entity
    
    StoryEntities can choose their following entity themselfs. the entity id defined here
    will be startet after this entity ends. this can be convenient if you want to have a
    non linear story with switches.
*/
void StoryEntity::setNextStoryID(int nextStoryID)
{
  this->nextStoryID = nextStoryID;
}

/** 
    \brief gets the story id of the current entity
    \returns story id
*/
int StoryEntity::getNextStoryID()
{
  return this->nextStoryID;
}


/**
   \brief stuff that will have to be initialized before load

   this gives all storyentities the possibility to init stuff before the
   load function, where all the stuff is been made ready for start
*/
ErrorMessage StoryEntity::preLoad()
{}

/** 
    \brief loads the current entity

    this is here to enable you loading maps into the entities. for all other actions you
    should take the init() function.
    load() is exec before init()
*/
ErrorMessage StoryEntity::load()
{}


/** 
    \brief initialize the entity before use. 
    \returns an error code if not able to apply.

    After execution of this function, the Entity is ready to be played/executed, 
    this shifts the initialisation work before the execution - very important...
    init() is exec shortly before start()
*/
ErrorMessage StoryEntity::init()
{}


/** 
    \brief starts the entity with the choosen id. only for entities with lists.
    \param story id
    \returns error code if this action has caused a error

    this simply starts the story with the id storyID. the story with the choosen id has
    to be part of the current entity else, this doesn't make sense. this is used for
    campaigns or the GameLoader, they have lists of Campaigns/Worlds with their own
    storyID.
*/
ErrorMessage StoryEntity::start(int storyID)
{}


/** 
    \brief starts the current entity
    \returns error code if this action has caused a error    
*/
ErrorMessage StoryEntity::start()
{}


/** 
    \brief pause the current entity
    \returns error code if this action has caused a error

    this pauses the current entity or passes this call forth to the running entity.
*/
ErrorMessage StoryEntity::pause()
{}


/** 
    \brief resumes a pause
    \returns error code if this action has caused a error

    this resumess the current entity or passes this call forth to the running entity.
*/
ErrorMessage StoryEntity::resume()
{}


/** 
    \brief stops the current entity
    \returns error code if this action has caused a error

    ATTENTION: this function shouldn't call other functions, or if so, they must return
    after finishing. If you ignore or forget to do so, the current entity is not able to
    terminate and it will run in the background or the ressources can't be freed or even
    worse: are freed and the program will end in a segmentation fault!
    hehehe, all seen... :)
*/
ErrorMessage StoryEntity::stop()
{}


/** 
    \brief destroys and cleans up the current entity. 

    this cleans up ressources before the deconstructor is called. for terminating 
    the entity please use the stop() function.
*/
ErrorMessage StoryEntity::destroy()
{}


/** 
    \brief this displays the load screen

    it will need some time to load maps or things like that. to inform the user about 
    progress and to just show him/her something for the eyes, put here this stuff
*/
void StoryEntity::displayLoadScreen()
{}


/** 
    \brief undisplay the load screen

    the load process has terminated, you now can release the load screen and start this
    entity.
*/
void StoryEntity::releaseLoadScreen()
{}
