/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "graphics_engine.h"

#include "debug.h"

using namespace std;


/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
GraphicsEngine::GraphicsEngine () 
{
  this->setClassName ("GraphicsEngine");
  this->initVideo();

  this->listModes();


}

GraphicsEngine* GraphicsEngine::singletonRef = NULL;

GraphicsEngine* GraphicsEngine::getInstance()
{
  if (!GraphicsEngine::singletonRef)
    GraphicsEngine::singletonRef = new GraphicsEngine();
  return GraphicsEngine::singletonRef;
}


/**
   \brief destructs the graphicsEngine.
*/
GraphicsEngine::~GraphicsEngine () 
{
  // delete what has to be deleted here
}

/**
   \brief initializes the Video for openGL.

   This has to be done only once when starting orxonox.
*/
int GraphicsEngine::initVideo()
{
  // initialize SDL_VIDEO
  if (SDL_Init(SDL_INIT_VIDEO) == -1)
    {
      PRINTF(1)("could not initialize SDL Video\n");
      //      return -1;
    }
  // initialize SDL_GL-settings
  this->setGLattribs();

  // setting the Video Flags.
  this->videoFlags = SDL_OPENGL | SDL_HWPALETTE | SDL_RESIZABLE;

  /* query SDL for information about our video hardware */
  const SDL_VideoInfo* videoInfo = SDL_GetVideoInfo ();
  if( videoInfo == NULL)
    {
      PRINTF(1)("Failed getting Video Info :%s\n", SDL_GetError()); 
      SDL_Quit ();
    }
  if( videoInfo->hw_available)
    this->videoFlags |= SDL_HWSURFACE;
  else 
    this->videoFlags |= SDL_SWSURFACE;
  /*
  if(VideoInfo -> blit_hw)                            
    VideoFlags |= SDL_HWACCEL;
  */

  // setting up the Resolution
  this->setResoulution(800, 600, 16);
  
  // Set window labeling
  SDL_WM_SetCaption ("Orxonox " PACKAGE_VERSION, "Orxonox " PACKAGE_VERSION);
  
  // TO DO: Create a cool icon and use it here
  // SDL_WM_SetIcon(SDL_Surface *icon, Uint8 *mask);  

}


int GraphicsEngine::setGLattribs(void)
{
  // Set video mode
  // TO DO: parse arguments for settings
  //SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
  

  SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );   
  SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16);    
  SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);  
  SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);
}

int GraphicsEngine::setResoulution(int width, int height, int bpp)
{
  this->resolutionX = width;
  this->resolutionY = height;
  this->bitsPerPixel = bpp;
  
  if((this->screen = SDL_SetVideoMode (this->resolutionX, this->resolutionY, this->bitsPerPixel, this->videoFlags)) == NULL)
    {
      PRINTF(1)("Could not SDL_SetVideoMode(%d, %d, %d, %d): %s\n", this->resolutionX, this->resolutionY, this->bitsPerPixel, this->videoFlags, SDL_GetError());
      SDL_Quit();
      //    return -1;
    }

}







/**
   \brief outputs all the Fullscreen modes.
*/
void GraphicsEngine::listModes(void)
{
  /* Get available fullscreen/hardware modes */
  this->videoModes=SDL_ListModes(NULL, SDL_FULLSCREEN|SDL_HWSURFACE);
  
  /* Check is there are any modes available */
  if(this->videoModes == (SDL_Rect **)0){
    PRINTF(1)("No modes available!\n");
    exit(-1);
  }
  
  /* Check if our resolution is restricted */
  if(this->videoModes == (SDL_Rect **)-1){
    PRINTF(1)("All resolutions available.\n");
  }
  else{
    /* Print valid modes */
    PRINT(0)("Available Resoulution Modes are\n");
    for(int i = 0; this->videoModes[i]; ++i)
      PRINT(0)(" |  %d x %d\n", this->videoModes[i]->w, this->videoModes[i]->h);
  }
  
}
