#ifndef _PRIMITIVE_H
#define _PRIMITIVE_H

#include "world_entity.h"
#include "glincl.h"

typedef enum pForm {P_SPHERE = 0, P_CUBE, P_CYLINDER, P_DISK};

class Material;

class Primitive : public WorldEntity 
{
  friend class World;

 public:
  Primitive (pForm form);
  virtual ~Primitive ();

  void setForm(pForm form);
  void setSize(float size);
  void setSegments(int segments);
  void setMaterial(Material* material);
  void setTexture(char* name);
  

  virtual void tick (float time);
  virtual void hit (WorldEntity* weapon, Vector* loc);
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void draw ();



 private:
  GLUquadricObj* object; //!< the object to be rendered
  Material* material;    //!< A Material for the SkySphere.
  pForm form;
  char* textureName;
  float size;
  float segments;

  void glDrawCube();
};

#endif /* _PRIMITIVE_H */
