/*! 
    \file graphics_engine.h
    
    \brief defines a Interface between orxonox and graphical input

    handles graphical SDL-initialisation, textures, resolutions, and so on
*/

#ifndef _GRAPHICS_ENGINE_H
#define _GRAPHICS_ENGINE_H

#include "glincl.h"

#include "base_object.h"

// FORWARD DEFINITION \\


class GraphicsEngine : public BaseObject 
{
 public:
  static GraphicsEngine* getInstance();
  virtual ~GraphicsEngine();

  int initVideo();
  int setResoulution(int width, int height, int bpp);

  static bool texturesEnabled;

 private:
  GraphicsEngine();
  static GraphicsEngine* singletonRef;


  SDL_Surface* screen;
  int resolutionX;
  int resolutionY;
  int bitsPerPixel;
  bool fullscreen;
  Uint32 videoFlags;
};

#endif /* _GRAPHICS_ENGINE_H */
