/*! 
    \file graphics_engine.h
    
    \brief defines a Interface between orxonox and graphical input

    handles graphical SDL-initialisation, textures, resolutions, and so on
*/

#ifndef _GRAPHICS_ENGINE_H
#define _GRAPHICS_ENGINE_H

#include <SDL/SDL.h>

#include "base_object.h"

// FORWARD DEFINITION \\


class GraphicsEngine : public BaseObject 
{
 public:
  static GraphicsEngine* getInstance();
  virtual ~GraphicsEngine();

 private:
  GraphicsEngine();
  static GraphicsEngine* singletonRef;


  SDL_Surface* screen;
};

#endif /* _GRAPHICS_ENGINE_H */
