/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "graphics_engine.h"

using namespace std;


/**
   \brief standard constructor
   \todo this constructor is not jet implemented - do it
*/
GraphicsEngine::GraphicsEngine () 
{
   this->setClassName ("GraphicsEngine");



  if (SDL_Init(SDL_INIT_VIDEO) == -1)
    {
      printf ("could not initialize SDL Video\n");
      //      return -1;
    }
  // Set video mode
  // TO DO: parse arguments for settings
  //SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
  //SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
  

  SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1 );   
  SDL_GL_SetAttribute( SDL_GL_DEPTH_SIZE, 16);    
  SDL_GL_SetAttribute( SDL_GL_STENCIL_SIZE, 0);  
  SDL_GL_SetAttribute( SDL_GL_ACCUM_RED_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_GREEN_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_BLUE_SIZE, 0);
  SDL_GL_SetAttribute( SDL_GL_ACCUM_ALPHA_SIZE, 0);



  int bpp = 16;
  int width = 640;
  int height = 480;
  //Uint32 flags = SDL_HWSURFACE | SDL_OPENGL | SDL_GL_DOUBLEBUFFER; /* \todo: SDL_OPENGL doen't permit to load images*/
  //Uint32 flags = SDL_HWSURFACE | SDL_GL_DOUBLEBUFFER;

  Uint32 videoFlags = SDL_OPENGL | SDL_HWPALETTE | SDL_RESIZABLE;

  /* query SDL for information about our video hardware */
  const SDL_VideoInfo* videoInfo = SDL_GetVideoInfo ();
  
  if( videoInfo == NULL)
    {
      printf ("Orxonox::initVideo() - Failed getting Video Info :%s\n", SDL_GetError()); 
      SDL_Quit ();
    }
  if( videoInfo->hw_available)
    videoFlags |= SDL_HWSURFACE;
  else 
    videoFlags |= SDL_SWSURFACE;
  /*
  if(VideoInfo -> blit_hw)                            
    VideoFlags |= SDL_HWACCEL;
  */
  
  if((this->screen = SDL_SetVideoMode (width, height, bpp, videoFlags)) == NULL)
  {
    printf("Could not SDL_SetVideoMode(%d, %d, %d, %d): %s\n", width, height, bpp, videoFlags, SDL_GetError());
    SDL_Quit();
    //    return -1;
  }
  
  // Set window labeling
  SDL_WM_SetCaption ("Orxonox " PACKAGE_VERSION, "Orxonox " PACKAGE_VERSION);
  
  // TO DO: Create a cool icon and use it here
  // SDL_WM_SetIcon(SDL_Surface *icon, Uint8 *mask);  



}

GraphicsEngine* GraphicsEngine::singletonRef = NULL;

GraphicsEngine* GraphicsEngine::getInstance()
{
  if (!GraphicsEngine::singletonRef)
    GraphicsEngine::singletonRef = new GraphicsEngine();
  return GraphicsEngine::singletonRef;
}


/**
   \brief standard deconstructor

*/
GraphicsEngine::~GraphicsEngine () 
{
  // delete what has to be deleted here
}

