/*! 
    \file skysphere.h
    \brief Definition of the Skysphere, that handles the Display of an atmosphere of orxonox.

    A SkySphere is always centered at the current working Camera, and will only obey the cameras
    movment but not its rotation.

    \todo self-rotation
    \todo handle reference to parent-object
*/

#ifndef _SKYSPHERE_H
#define _SKYSPHERE_H

/* INCLUDES */
#include "world_entity.h"

/* FORWARD DEFINITION */
class Material;
class Vector;

//! A Class to handle a SkySphere
class Skysphere : public WorldEntity
{

 public:
  Skysphere();
  Skysphere(char* fileName);
  virtual ~Skysphere();
  void destroy();

  void setRadius(float radius);
  void setTexture(char* fileName);

  virtual void draw();

 private: 
  GLUquadricObj *sphereObj; //!< A Placeholder for the SkySphere.
  Material *skyMaterial;    //!< A Material for the SkySphere.
  float sphereRadius;       //!< Radius of the SkySphere. This should match the frustum maximum range.
    
  void initialize(char* fileName);  
};

#endif  /* _SKYSPHERE_H */



