#ifndef _PRIMITIVE_H
#define _PRIMITIVE_H

#include "world_entity.h"
#include "glincl.h"

typedef enum PRIMITIVE_FORM {PSPHERE = 0, PCUBE, PSQUARE};

class Material;


class Primitive : public WorldEntity 
{
  friend class World;

 public:
  Primitive (PRIMITIVE_FORM form);
  virtual ~Primitive ();

  virtual void tick (float time);
  virtual void hit (WorldEntity* weapon, Vector* loc);
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void draw ();

 private:
  GLUquadricObj *object; //!< the object to be rendered
  Material *material;    //!< A Material for the SkySphere.

};

#endif /* _PRIMITIVE_H */
