/*! 
    \file player.h
    \brief Implements a basic controllable WorldEntity
*/

#ifndef _PLAYER_H
#define _PLAYER_H

#include "world_entity.h"

template<class T> class tList;
class OBJModel;
class Weapon;
class Vector;

//! Basic controllable WorldEntity
class Player : public WorldEntity 
{
  friend class World;
  
 public:
  Player(bool isFree = false);
  virtual ~Player();

  void addWeapon(Weapon* weapon);
  void removeWeapon(Weapon* weapon);
  
  virtual void postSpawn();
  virtual void leftWorld();
  virtual void hit(WorldEntity* weapon, Vector* loc);
  virtual void collide(WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags);

  virtual void tick(float time);  
  virtual void draw();

  virtual void command(Command* cmd);
  
 private:
  bool bUp;              //!< up button pressed.
  bool bDown;            //!< down button pressed.
  bool bLeft;            //!< left button pressed.
  bool bRight;           //!< right button pressed.
  bool bAscend;          //!< ascend button pressed.
  bool bDescend;         //!< descend button presses.
  bool bFire;            //!< fire button pressed.
  bool bWeaponChange;    //!< weapon change button pressed

  tList<Weapon>* weapons;//!< a list of weapon
  Weapon* activeWeapon;  //!< the weapon that is currenty activated

  Vector* velocity;       //!< the velocity of the player.
  float travelSpeed;     //!< the current speed of the player (to make soft movement)
  float acceleration;    //!< the acceleration of the player.
  
  void move(float time);
  void fire(void);
  
};

#endif /* _PLAYER_H */
