
#ifndef _CAMPAIGN_H
#define _CAMPAIGN_H

#include "stdincl.h"
#include "story_entity.h"


class World;
template<class T> class tList;

class Campaign : public StoryEntity {

 public:
  Campaign ();
  virtual ~Campaign ();

  StoryEntity* currentEntity;

  virtual ErrorMessage init();
  virtual ErrorMessage start();
  virtual ErrorMessage start(int storyID);
  virtual ErrorMessage pause();
  virtual ErrorMessage resume();
  virtual ErrorMessage stop();
  virtual ErrorMessage destroy();

  void addEntity(StoryEntity* se, int storyID);
  void addEntity(StoryEntity* se);
  void removeEntity(int storyID);
  void removeEntity(StoryEntity* se);
  
  void nextLevel();
  void previousLevel();

 private:
  //ListTemplate<StoryEntity>* entities;
  tList<StoryEntity>* entities;
  bool running;

  StoryEntity* getStoryEntity(int storyID);
};

#endif /* _CAMPAIGN_H */
