/*!
	\file message_structures.h
	\brief contains defintitons of messages that can be passed between classes
*/

#ifndef _MESSAGE_STRUCTURES_H
#define _MESSAGE_STRUCTURES_H

#include "stdincl.h"

#define CMD_LENGHT 16

//! structure that contains a command message
typedef struct
{
	char cmd[CMD_LENGHT];	//!< the command delivered
	bool bUp;	//!< false = command was activated / true = command was deactivated
	
	//! if cmd is "cursor" the coordinates of the mouse cursor are stored here
	//!@{
	Uint16 x, y;
	//!@}
	
	//! if cmd is "cursor" the relative motion of the mouse cursor is stored here
	//!@{
	Sint16 xrel, yrel; 
	//!@}
} Command;

#endif /* _MESSAGE_STRUCTURES_H */
