#ifndef _GAME_LOADER_H
#define _GAME_LOADER_H

//#include "stdincl.h"
#include "story_def.h"
#include "comincl.h"

//-----------------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------------
class Campaign;
class World;
class Camera;
class CammandNode;

class GameLoader 
{

 public:
  static GameLoader* getInstance();

  ErrorMessage init();
  ErrorMessage loadCampaign(char* name);
  ErrorMessage start();
  ErrorMessage stop();
  ErrorMessage pause();
  ErrorMessage resume();
  ErrorMessage destroy();

  void nextLevel();
  void previousLevel();

  bool worldCommand(Command* cmd);
  ErrorMessage loadDebugCampaign(Uint32 campaignID);
  
 private:
  GameLoader ();
  ~GameLoader ();
  Uint32 startTime; //!> start time of the campaign
  static GameLoader* singletonRef;
  bool isPaused;

  Campaign* currentCampaign; //!> the current campaign playing
  
  Campaign* fileToCampaign(char* name);

};

#endif /* _GAME_LOADER_H */
