/*! 
    \file camera.h
    \brief Viewpoint controlling class definitions
*/ 

#ifndef _CAMERA_H
#define _CAMERA_H

#include "world_entity.h"

class World;

//! Camera
/**
   This class controls the viewpoint from which the World is rendered. To use the 
   Camera it has to be bound to a WorldEntity which serves as the reference focus 
   point. The Camera itself calls the WorldEntity::get_lookat() and 
   World::calc_camera_pos() functions to calculate the position it currently should
   be in.
*/

enum CAMERA_MODE {NORMAL, SMOTH_FOLLOW, STICKY, ELLIPTICAL};

class Camera : public WorldEntity {
 private:
  WorldEntity* bound;		//!< the WorldEntity the Camera is bound to
  World* world;
  
  /* physical system - not needed yet */
  float m; //!< mass
  Vector *fs; //!< seil-kraft
  Vector *a;  //!< acceleration
  Vector *v;  //!< velocity
  
  /* elliptical camera mode variables */
  float cameraOffset;
  float cameraOffsetZ;
  float deltaTime;
  float t;
  Vector* r;
  float rAbs;
  float ka;
  float a0;

  Quaternion *from;
  Quaternion *to;
  Quaternion *res;
  
  
  CAMERA_MODE cameraMode; //!< saves the camera mode: how the camera follows the entity
  
  void updateDesiredPlace ();
  
 public:
  Camera (World* world);
  virtual ~Camera ();
  
  void tick (Uint32 deltaT);
  void apply ();
  void bind (WorldEntity* entity);

  void setWorld(World* world);  

};

#endif /* _CAMERA_H */
