

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/

#include "camera.h"

#include "world.h"
#include "world_entity.h"
#include "vector.h"

using namespace std;

/**
   \brief creates a Camera
   
   This standard constructor sets all parameters to zero
*/
Camera::Camera (World* world)
{
  this->world = world;
  this->bound = NULL;
  /* give it some physical live */
  this->m = 10;
  this->a = new Vector(0.0, 0.0, 0.0);
  this->v = new Vector(0.0, 0.0, 0.0);
  this->fs = new Vector(0.0, 0.0, 0.0);
  this->cameraMode = NORMAL;
  this->deltaTime = 3000.0;
  this->cameraOffset = 1.0;
  this->cameraOffsetZ = 10.0;
  this->t = 0.0;


  this->setDrawable (false);
}

/**
   \brief default destructor
*/
Camera::~Camera ()
{
  this->bound = NULL;
  this->world = NULL;

}

/**
   \brief time based actualisation of camera parameters
   \param deltaT: The amount of time that has passed in milliseconds
   
   This is called by the World in every time_slice, use it to do fancy time dependant effects (such 
   as smooth camera movement or swaying).
*/
void Camera::tick (Uint32 deltaT)
{
  if( this->t <= deltaTime)
    {this->t += deltaT;}
  //printf("time is: t=%f\n", t );
  updateDesiredPlace();
  //jump(NULL);
}

/**
   \brief this calculates the location where the track wants the camera to be
   
   This refreshes the placement the camera should have according to the 
   bound entity's position on the track.
*/
void Camera::updateDesiredPlace ()
{
  switch(cameraMode)
    {
      
    case ELLIPTICAL:
      {
	/*
	//r = actual_place.r 
	Orxonox *orx = Orxonox::getInstance();
	Location lookat;  
	Placement plFocus;
	if( bound != NULL)
	  {
	    bound->getLookat (&lookat);
	    orx->getWorld()->calcCameraPos (&lookat, &plFocus);
	    Quaternion *fr;
	    if(t < 20.0)
	      {
		Vector *start = new Vector(0.0, 1.0, 0.0);
		r = *(new Vector(0.0, 5.0, 0.0));

		Vector up(0.0, 0.0, 1.0);
		
		Vector op(1.0, 0.0, 0.0);
		float angle = angleDeg(op, *start);
		printf("angle is: %f\n", angle);

		//if in one plane
		from = new Quaternion(angle, up);

		//from = new Quaternion(*start, *up);
		//&from = &plFocus.w;
		//fr = &plFocus.w; real quaternion use
		


		Vector vDirection(1.0, 0.0, 0.0);
		//vDirection = plFocus.w.apply(vDirection);
		to = new Quaternion(vDirection, *start);
		res = new Quaternion();
	      }
	    //printf("vector r = %f, %f, %f\n",r.x, r.y, r.z );
	    rAbs = r.len();
	    if(t < 30)
	      {
		ka = rAbs / deltaTime*deltaTime;
	      }

	    res->quatSlerp(to, from, t/deltaTime, res);

	    Vector ursp(0.0, 0.0, 0.0);
	    desiredPlace.r =  ursp - res->apply(r); 

	    printf("desired place is: %f, %f, %f\n", desiredPlace.r.x, desiredPlace.r.y, desiredPlace.r.z);
	    //plLastBPlace = *bound->get_placement();
	    
	  } 
      */
      }
      break;
    case SMOTH_FOLLOW:
      {
	/*
	Placement *plBound = bound->getPlacement();
	Location lcBound;
	if(bound != null)
	  {
	    bound->getLookat(&lcBound);
	    Vector vDirection(0.0, 0.0, 1.0);
	    vDirection = plBound->w.apply(vDirection);
	    desiredPlace.r = (vDirection * ((lcBound.dist-10.0))) + Vector(0,0,5.0);
	  }
	*/
	break;
      }
      /* this is a camera mode that tries just to follow the entity. */
    case STICKY:
      {
	/*
	if(bound != null)
	  {
	    Placement *plBound = bound->getPlacement();
	    Vector vDirection(0.0, 0.0, 1.0);
	    Vector eclipticOffset(0.0, 0.0, 5.0);
	    vDirection = plBound->w.apply(vDirection);
	    desiredPlace.r = plBound->r - vDirection*10 + eclipticOffset;
	  }
	*/
	break;
      }
      /* the camera is handled like an entity and rolls on the track */
    case NORMAL:
      if( bound != NULL && world != NULL )
	{
	  //FIXME: camera should be made via relative coordinates
	  Vector* cameraOffset = new Vector (-10, 5, 0);
	  this->setRelCoor (cameraOffset);
	} 
      else
	{
	  /*
	  desiredPlace.r = Vector (0,0,0);
	  desiredPlace.w = Quaternion (); 
	  */
	}
      break;
    }
}

/**
   \brief initialize rendering perspective according to this camera
   
   This is called immediately before the rendering cycle starts, it sets all global
   rendering options as well as the GL_PROJECTION matrix according to the camera.
*/
void Camera::apply ()
{
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  // view
  // TO DO: implement options for frustum generation
  //glFrustum(-1.0, 1.0, -1.0, 1.0, 1.5, 250.0);
  gluPerspective(60, 1.2f, 0.1, 2000);
  
  //Vector up(0,0,1);
  //Vector dir(1,0,0);
  //Quaternion q(dir,up);
  //float matrix[4][4];
  //q.conjugate().matrix (matrix);
  //glMultMatrixf ((float*)matrix);
  //glTranslatef (10,0,-5);
  //
  //dir = Vector(-1,-1,0);
  //q = Quaternion( dir, up);
  //glMatrixMode (GL_MODELVIEW);
  //glLoadIdentity ();
  //q.matrix (matrix);
  //glMultMatrixf ((float*)matrix);
  //glTranslatef (2,2,0);
  //
  //glBegin(GL_TRIANGLES);
  //glColor3f(1,0,0);
  //glVertex3f(0,0,0.5);
  //glColor3f(0,1,0);
  //glVertex3f(-0.5,0,-1);
  //glColor3f(0,0,1);
  //glVertex3f(0.5,0,-1);
  //glEnd();	

  // ===== first camera control calculation option
  // rotation
  float matrix[4][4];
  //this->absDirection.conjugate().matrix (matrix);
  /* orientation and */
  //glMultMatrixf ((float*)matrix);

  /*  translation */
  //glTranslatef (this->absCoordinate.x, this->absCoordinate.y, this->absCoordinate.z );


  // ===== second camera control calculation option

  Vector r = this->getAbsCoor();
  gluLookAt(r.x, r.y, r.z, 
	    this->parent->getAbsCoor ().x, this->parent->getAbsCoor ().y, this->parent->getAbsCoor ().z,
	    0.0, 1.0, 0.0);
  

  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
}



/**
  \brief bind the camera to an entity
  \param entity: The enitity to bind the camera to
	
  This sets the focus of the camera to the given entity. This means that it will use the given WorldEntity's
  Location and get_lookat() to determine the viewpoint the camera will render from.
  Note that you cannot bind a camera to a free entity.
*/
void Camera::bind (WorldEntity* entity)
{
  if( entity != NULL)
    {
      if( entity->isFree()) printf("Cannot bind camera to free entity");
      else 
	{
	  this->bound = entity;
	}
    } 
}


void Camera::setWorld(World* world)
{
  this->world = world;
}


