/*!
  \file stdincl.h
  \brief This file includes default headers that nearly every Class needs.
  
  no Class is defined here, but many headers to classes, and more general Headers like the openGL-header.
*/

#ifndef _STDINCL_H
#define _STDINCL_H

#define null 0   //!< null


typedef unsigned char byte;

// this includes the information from configure/makefiles
#if HAVE_CONFIG_H 
#include <config.h> 
#endif

#ifdef __WIN32__
#include <windows.h>
#endif

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include "glincl.h"


// MATH //
#include "vector.h"

#include "list.h"
#include "list_template.h"
#include "message_structures.h"
#include "orxonox.h"
#include "data_tank.h"
#include "base_object.h"

#include "error.h"
#include "debug.h"

#endif /* _STDINCL_H */
