

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "primitive.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "objModel.h"

using namespace std;



/**
   \brief standard constructor
*/
Primitive::Primitive (PRIMITIVE_FORM form) : WorldEntity()
{
  //this->model = new OBJModel("../data/models/fighter.obj");
  //this->model = new OBJModel("");
  this->object = gluNewQuadric();
  
  gluQuadricTexture(this->object, GL_TRUE);

  this->material = new Material("Sphere");
  this->material->setDiffuseMap("../data/pictures/load_screen.jpg");
  this->material->setIllum(3);
  this->material->setAmbient(1, 1, 1);
}


/**
   \brief standard deconstructor
*/
Primitive::~Primitive () 
{
  delete this->material;
  free(this->object);
}

/**
   \brief called, when the object gets hit
   \param other object, that hits it
   \param location of impact
*/
void Primitive::hit (WorldEntity* weapon, Vector* loc) {}


/**
   \brief object collides
*/
void Primitive::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}


/**
   \brief tick singal put everything here, that is timedependent
   \param time in sec
*/
void Primitive::tick (float time) 
{
  //  Vector v(0.0, 0.0, 1.0);
  //  Quaternion q(10.0, v);
  //  this->setRelDir(&(this->relDirection * q));
}

/**
   \brief drawing function of the object
*/
void Primitive::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  //rotate
  //this->getAbsDir().matrix (matrix);
  //glMultMatrixf((float*)matrix);
  this->material->select();
  gluSphere(this->object, 2, 20, 20);

  glPopMatrix();
}

