

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "weapon.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "objModel.h"
#include "projectile.h"

using namespace std;


/**
   \brief standard constructor

   creates a new weapon
*/
Weapon::Weapon () : WorldEntity()
{
  this->model = new OBJModel("");
}


/**
   \brief standard deconstructor
*/
Weapon::~Weapon () 
{
  delete this->model;
}


/** 
    \brief enables the weapon

    a weapon can be enabled/disabled because of various reasons. if a weapon is 
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
void Weapon::enable()
{}


/** 
    \brief disables the weapon

    a weapon can be enabled/disabled because of various reasons. if a weapon is 
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
void Weapon::disable()
{}


/** 
    \brief checks if the weapon is enabled
    \returns true if enabled

    a weapon can be ebabled/disabled because of various reasons. if a weapon is 
    been enabled, it can interact in a world. elswhere it wont react to any
    action.
*/
bool Weapon::isEnabled()
{}


/**
   \brief sets a new projectile to the weapon
   \param new projectile for this weapon

   weapon an projectile are independent, so you can combine them as you want
*/
void Weapon::setProjectile(Projectile* projectile)
{
  this->projectile = projectile;
}


/**
   \brief sets a new projectile to the weapon
   \returns the current projectile of this weapon

   weapon an projectile are independent, so you can combine them as you want
*/
Projectile* Weapon::getProjectile()
{
  return this->projectile;
}


/**
   \brief this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out. 
*/
void Weapon::activate()
{}


/**
   \brief this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the 
   activation can be connected with an animation. for example the weapon is 
   been armed out.
*/
void Weapon::deactivate()
{}

/**
   \brief asks if the current weapon is active
   \returns true if it the weapon is active
*/
bool Weapon::isActive()
{}


/**
   \brief this sets the energy of a weapon
   \param amount of energy

   a weapon has a limited amount of energy, this means a limited amount of shoots
*/
void Weapon::setWeaponEnergy(int energy)
{}

/**
   \brief adds weapon energy
   \param amount of energy
   \returns amount of energy, that is over the energy limit

   this can be used for energy-power up for example. There is a limited amount of energy
   a weapon can have. so if you want to add more, than it supports, the rest will
   be returned from this weapon.
*/
int Weapon::addWeaponEnergy(int addEnergy)
{}

/**
   \brief removes weapon energy
   \param amount of enery

   this is the case, when ther should be some sort of energy loss in the weapon
   system. propably wont be the case but usefull to have
*/
void Weapon::substractWeaponEnergy(int subEnergy)
{}

/**
   \brief gets the amount of energy of a weapon (= ammo)
*/
int Weapon::getWeaponEnergy()
{}


/**
   \brief fires the weapon
   
   this is called from the player.cc, when fire-button is been pushed
*/
void Weapon::fire()
{}


/**
   \brief is called, when the weapon gets hit (=collide with something)
   \param from which entity it is been hit
   \param where it is been hit

   this may not be used, since it would make the game relay complicated when one
   can destroy the weapons of enemies or vice versa.
*/
void Weapon::hit (WorldEntity* entity, Vector position) 
{}


/**
   \brief is called, when the weapon is destroyed

   this is in conjunction with the hit function, so when a weapon is able to get
   hit, it can also be destoryed.
*/
void Weapon::destroy () 
{}


/**
   \brief tick signal for time dependent/driven stuff
*/
void Weapon::tick (float time) 
{}


/**
   \brief this will draw the weapon
*/
void Weapon::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  this->model->draw();

  glPopMatrix();
}

