

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "weapon.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "objModel.h"

using namespace std;



Weapon::Weapon () : WorldEntity()
{
  this->model = new OBJModel("../data/models/fighter.obj");
}



Weapon::~Weapon () 
{
  delete this->model;
}

void Weapon::tick (float time) {}

void Weapon::hit (WorldEntity* weapon, Vector loc) {}

void Weapon::destroy () {}

void Weapon::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}

void Weapon::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  //rotate
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();

  glPopMatrix();
}

