/*! 
    \file simple_animation.h
    \brief A class to interpolate the movement of an object following descrete points in room and time
    \todo implement it

    This class has been done to animate some movement, works best for short 
    distances.
*/

#ifndef _SIMPLE_ANIMATION_H
#define _SIMPLE_ANIMATION_H

#include "base_object.h"
#include "p_node.h"
#include "list.h"


typedef enum movementMode{LINEAR=0, EXP, NEG_EXP, SIN, COS};


//! KeyFrame Class
/**
   This represents one point with orientation of the animation
*/
class KeyFrame : public PNode {
 public:
  KeyFrame(Vector* point, Quaternion* orientation, float time);
  KeyFrame(Vector* point, Quaternion* orientation, float time, movementMode mode); 
  virtual ~KeyFrame();

  void set(Vector* point, Quaternion* orientation, float time);
  void set(Vector* point, Quaternion* orientation, float time, movementMode mode);
  
 private:
  float time;
  movementMode mode;
};


//! Animation Class
/**
   Helps you making some small animation
*/
class SimpleAnimation : public BaseObject {
  
 public:
  SimpleAnimation(PNode* parent);
  virtual ~SimpleAnimation();

  void addKeyFrame(Vector* point, Quaternion* orientation, float time);
  void addKeyFrame(Vector* point, Quaternion* orientation, float time, movementMode mode);
  void addKeyFrame(KeyFrame* frame);
  void reset();

  void start();
  void stop();
  void restart();
  void pause();
  void resume();

  void tick(float time);

 private:
  bool bPause;                     //<! is set, when there is a pause
  tList<KeyFrame>* frames;        //<! where keyframes are stored in
  float localTime;
  PNode* parent;
  

};

#endif /* _SIMPLE_ANIMATION_H */
