

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


#include "simple_animation.h"
#include "stdincl.h"
#include "p_node.h"

using namespace std;

/**
   \brief standard constructor
   \param the point of the object
   \param and the orientation of it
   \param at this time
*/
KeyFrame::KeyFrame(Vector* point, Quaternion* orientation, float time)
{
  this->setRelCoor(point);
  this->setRelDir(orientation);
  this->time = time;
}


/**
   \brief standard constructor
   \param the point of the object
   \param and the orientation of it
   \param at this time
   \param function of the velocity of the movement 
*/
KeyFrame::KeyFrame(Vector* point, Quaternion* orientation, float time, movementMode mode)
{
  this->setRelCoor(point);
  this->setRelDir(orientation);
  this->time = time;
  this->mode = mode;
}


/**
   \brief standard deconstructor
*/
KeyFrame::~KeyFrame()
{
}


/**
   \brief sets the important properties of a Keyframe
   \param the point of the object
   \param and the orientation of it
   \param at this time
*/
void KeyFrame::set(Vector* point, Quaternion* orientation, float time)
{
  this->setRelCoor(point);
  this->setRelDir(orientation);
  this->time = time;
}


/**
   \brief sets the important properties of a Keyframe
   \param the point of the object
   \param and the orientation of it
   \param at this time
   \param function of the velocity of the movement 
*/
void KeyFrame::set(Vector* point, Quaternion* orientation, float time, movementMode mode)
{
  this->setRelCoor(point);
  this->setRelDir(orientation);
  this->time = time;
  this->mode = mode;
}



/**
   \brief standard constructor
*/
SimpleAnimation::SimpleAnimation (PNode* parent) 
{
   this->setClassName ("SimpleAnimation");
   this->frames = new tList<KeyFrame>();
   this->localTime = 0;
   this->bPause = false;
   this->parent = parent;
}


/**
   \brief standard deconstructor

*/
SimpleAnimation::~SimpleAnimation () 
{
  KeyFrame* frame = this->frames->enumerate(); 
  while( frame != NULL) 
    { 
      delete frame;
      frame = frames->nextElement();
    }
  delete this->frames;
}



/**
   \brief adds a keyframe with properties
   \param the point of the object
   \param and the orientation of it
   \param at this time
*/
void SimpleAnimation::addKeyFrame(Vector* point, Quaternion* orientation, float time)
{
  KeyFrame* frame = new KeyFrame(point, orientation, time);
  this->frames->add(frame);
}


/**
   \brief adds a keyframe with properties
   \param the point of the object
   \param and the orientation of it
   \param at this time
   \param function of the velocity of the movement 
*/
void SimpleAnimation::addKeyFrame(Vector* point, Quaternion* orientation, float time, movementMode mode)
{
  KeyFrame* frame = new KeyFrame(point, orientation, time, mode);
  this->frames->add(frame);
}

/**
   \brief adds a already defined keyframe
   \param the keyframe to add
*/
void SimpleAnimation::addKeyFrame(KeyFrame* frame)
{
  this->frames->add(frame);
}


/**
   \brief clear the list of keyframes, deleting all keyframes included
*/
void SimpleAnimation::reset()
{
  KeyFrame* frame = this->frames->enumerate(); 
  while( frame != NULL) 
    { 
      delete frame;
      frame = frames->nextElement();
    }
  delete this->frames;

  this->frames = new tList<KeyFrame>();
  this->localTime = 0;
  this->bPause = false;

}

/**
   \brief starts the animation, therefore listens to tick signals
*/
void SimpleAnimation::start()
{}


/**
   \brief stops the animation, immune to tick signals
*/
void SimpleAnimation::stop()
{}

/**
   \brief stops and then starts the animation from begining
*/
void SimpleAnimation::restart()
{
  this->localTime = 0;
  this->bPause = false;
}

/**
   \brief pauses the animation until resumed
*/
void SimpleAnimation::pause()
{
  this->bPause = true;
}

/**
   \brief resumes a pause, if not paused, no effect
*/
void SimpleAnimation::resume()
{
  this->bPause = false;
}


/**
   \brief heart beat, next animation step
*/
void SimpleAnimation::tick(float time)
{
  if(!this->bPause)
    {



    }
}
