/*! 
    \file glmenu_imagescreen
    \brief class to display a image
*/


#ifndef _GLMENU_IMAGESCREEN_H
#define _GLMENU_IMAGESCREEN_H

#include "base_object.h"

class Material;

class GLMenuImageScreen : public BaseObject {

 private:
  GLMenuImageScreen ();

 public:
  ~GLMenuImageScreen ();
  void destroy(void);

  static GLMenuImageScreen* getInstance();

  static GLMenuImageScreen* singletonRef;

  void init ();
  void init (char* backImageName, float height, float width, 
	     float offsetX, float offsetY);

  void draw ();
  
  void setBackImageName (char* backImageName);
  void setPosition (float offsetX, float offsetY);
  void setSize (float height, float width);
  
  void setMaximum (int maxValue);
  int getMaximum ();
  void setValue (int currentValue);
  int getValue ();
  void step ();

 private:
  char* backImageName;       //!< the name of the file of the background image
  float height, width;       //!< hight and width of the image
  float offsetX, offsetY;    //!< offset of the image from left and up
  Material* backMat;         //!< Background Material.
  int currentValue;          //!< the current count of step() calls fired yet
  int maxValue;              //!< total count of steps

};

#endif /* _GLMENU_IMAGESCREEN_H */
