

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "primitive.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "objModel.h"

using namespace std;


Primitive::Primitive (PRIMITIVE_FORM form) : WorldEntity()
{
  this->model = new OBJModel("../data/models/fighter.obj");
  //this->model = new OBJModel("");
}



Primitive::~Primitive () 
{
  delete this->model;
}

void Primitive::tick (float time) 
{
  Vector v(0.0, 0.0, 1.0);
  Quaternion q(10.0, v);
  this->relDirection = this->relDirection * q;
}

void Primitive::hit (WorldEntity* weapon, Vector loc) {}

void Primitive::destroy () {}

void Primitive::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}

void Primitive::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  //rotate
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();
  glPopMatrix();
}

