

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: Christian Meyer
*/

#include "player.h"
#include "stdincl.h"
//#include "collision.h"
#include "objModel.h"

using namespace std;

/**
   \brief creates a new Player
   \param isFree if the player is free
*/
Player::Player(bool isFree) : WorldEntity(isFree)
{
  this->model = new OBJModel("../data/models/reaplow.obj");
}

/**
   \brief destructs the player
*/
Player::~Player ()
{
  delete this->model;
}

/**
   \brief effect that occurs after the player is spawned
*/
void Player::postSpawn ()
{
  travelSpeed = 15.0;
  velocity = Vector();
  bUp = bDown = bLeft = bRight = bAscend = bDescend = false;
  bFire = false;
  acceleration = 10.0;
  //setCollision(new CollisionCluster(1.0, Vector(0,0,0)));
}

/**
   \brief the function called for each passing timeSnap
   \param time The timespan passed since last update
*/
void Player::tick (float time)
{
  // movement
  this->move (time);
}

/**
   \brief if the player is hit, call this function
   \param weapon hit by this weapon
   \param loc ??
*/
void Player::hit (WorldEntity* weapon, Vector loc)
{
}

/**
   \brief action that happens when the player is destroyed.
*/
void Player::destroy ()
{
}

/** 
    \brief Collision with another Entity has this effect
    \param other the other colider
    \param ownhitflags ??
    \param otherhitflags ??
*/
void Player::collide (WorldEntity* other, Uint32 ownhitflags, Uint32 otherhitflags)
{
}

/**
   \brief The connection to the command node
   \param cmd the Command unit from witch to map

   here the commands are mapped to the players movement/weaponary
*/
void Player::command (Command* cmd)
{
  //printf("Player|recieved command [%s]\n", cmd->cmd);
  if( !strcmp( cmd->cmd, "up")) bUp = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "down")) bDown = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "left")) bLeft = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "right")) bRight = !cmd->bUp;
  else if( !strcmp( cmd->cmd, "fire")) bFire = !cmd->bUp;
}

/**
   \brief draws the player after transforming him.
*/
void Player::draw ()
{ 
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  /* translate */
  glTranslatef (this->getAbsCoor ().x, 
		this->getAbsCoor ().y, 
		this->getAbsCoor ().z);
  /* rotate */
  this->getAbsDir ().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();
  glPopMatrix();
}


/*PN
  void Player::getLookat(Location* locbuf)
  {
  *locbuf = *getLocation();
  //locbuf->dist += 5.0;
  }
*/

/**
   \brief the action occuring if the player left the game
*/
void Player::leftWorld ()
{
}

/**
   \brief action if player moves
   \param time the timeslice since the last frame
*/
void Player::move (float time)
{
  Vector accel(0.0, 0.0, 0.0);
  /* FIXME: calculating the direction and orthDirection every timeSlice is redundant! save it somewhere */
  //Placement *pos = getPlacement();
  
  /* calculate the direction in which the craft is heading  */
  Vector direction (1.0, 0.0, 0.0);
  //direction = this->absDirection.apply (direction);
  Vector orthDirection (0.0, 0.0, 1.0);
  //orthDirection = orthDirection.cross (direction);

  if( bUp) { accel = accel+(direction*acceleration); }
  if( bDown) { accel = accel-(direction*acceleration); }
  if( bLeft ) { accel = accel - (orthDirection*acceleration); }
  if( bRight ) { accel = accel + (orthDirection*acceleration); }
  if( bAscend ) { /* not yet implemented but just: (0,0,1)*acceleration */}
  if( bDescend) {/* FIXME */} /* \todo up and down player movement */

  //Location* l = getLocation();
  
  // r(t) = r(0) + v(0)*t + 1/2*a*t^2
  // r = position
  // v = velocity
  // a = acceleration

  /* this the base-speed of the player: determines how fast and how the player follows the track*/
  //l->dist = l->dist + travelSpeed * time;
  
  Vector* shift = new Vector (this->travelSpeed * time, 0, 0);
  this->shiftCoor (shift);
  
  /* this updates the player position on the track - user interaction */
  //l->pos = l->pos + accel*time;
  Vector move = accel * time;
  this->shiftCoor (&move);
}
