

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: 
*/


#include "environment.h"
#include "stdincl.h"
#include "world_entity.h"
#include "vector.h"
#include "objModel.h"

using namespace std;



Environment::Environment () : WorldEntity()
{
  this->model = new OBJModel("../data/models/fighter.obj");
}



Environment::~Environment () 
{
  delete this->model;
}

void Environment::tick (float time) {}

void Environment::hit (WorldEntity* weapon, Vector loc) {}

void Environment::destroy () {}

void Environment::collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags) {}

void Environment::draw () 
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  float matrix[4][4];
  
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  //rotate
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  
  this->model->draw();

  glPopMatrix();
}

