/*! 
    \file world.h
    \brief Holds and manages all game data
*/ 

#ifndef _WORLD_H
#define _WORLD_H

#include "stdincl.h"
#include "story_entity.h"


class TrackManager;
class WorldEntity;
class Camera;
class PNode;
class GLMenuImageScreen;
class Skysphere;
class Light;
class FontSet;

//! The game world
/**
   this class initializes everything that should be displayed inside of the current level.
   it is the main driving factor during gameplay.
*/
class World : public StoryEntity {

 public:
 	World (TiXmlElement* root),
  World (char* name);
  World (int worldID);
  virtual ~World ();


  /* classes from story-entity */
  virtual ErrorMessage load ();
  virtual ErrorMessage init ();
  virtual ErrorMessage start ();
  virtual ErrorMessage stop ();
  virtual ErrorMessage pause ();
  virtual ErrorMessage resume ();
  virtual ErrorMessage destroy ();

  virtual void displayLoadScreen();
  virtual void releaseLoadScreen();
  
  /* command node functions */
  bool command (Command* cmd);

  /* interface to world */
  void spawn (WorldEntity* entity);
  void spawn (WorldEntity* entity, Vector* absCoor, Quaternion* absDir);
	
	void setPath( char* name);
	char* getPath();


 private:
  Uint32 lastFrame;             //!< last time of frame
  bool bQuitOrxonox;            //!< quit this application
  bool bQuitCurrentGame;        //!< quit only the current game and return to menu
  bool bPause;                  //!< pause mode

  FontSet* testFont;            //!< A test Font. \todo fix this, so it is for real.
  GLMenuImageScreen* glmis;     //!< The Level-Loader Display

  char* worldName;              //!< The name of this World
  char* path;										//!< The path to the data file used by this World
  int debugWorldNr;             //!< The Debug Nr. needed, if something goes wrong

  PNode* nullParent;            //!< The zero-point, that everything has as its parent.
  TrackManager* trackManager;  //!< The reference of the TrackManager that handles the course through the Level.
  Camera* localCamera;         //!< The current Camera
  Skysphere* skySphere;         //!< The Environmental Heaven of orxonox \todo insert this to environment insted
  Light* light;                 //!< The Lights of the Level

  GLuint objectList;            //!< temporary: \todo this will be ereased soon
  tList<WorldEntity>* entities;//!< A template List of all entities. Every moving thing should be included here, and world automatically updates them.
  WorldEntity* localPlayer;     //!< The Player, you fly through the level.
 
  /* function for main-loop */
  void mainLoop ();
  void synchronize ();
  void handleInput ();
  void timeSlice ();
  void collide ();
  void draw ();
  void display ();
  void debug ();

};

CREATE_FACTORY(World);

#endif /* _WORLD_H */
