
#ifndef _CAMPAIGN_HCREATE_FACTORY
#define _CAMPAIGN_H

#include "stdincl.h"
#include "story_entity.h"


class World;

class Campaign : public StoryEntity {

 public:
  Campaign ();
  Campaign ( TiXmlElement* root);
  ~Campaign ();

  StoryEntity* currentEntity;

  virtual ErrorMessage init();
  virtual ErrorMessage start();
  virtual ErrorMessage start(int storyID);
  virtual ErrorMessage pause();
  virtual ErrorMessage resume();
  virtual ErrorMessage stop();
  virtual ErrorMessage destroy();

  void addEntity(StoryEntity* se, int storyID);
  void addEntity(StoryEntity* se);
  void removeEntity(int storyID);
  void removeEntity(StoryEntity* se);
  
  void nextLevel();
  void previousLevel();

 private:
  ListTemplate<StoryEntity>* entities;
  bool running;

  StoryEntity* getStoryEntity(int storyID);
};

CREATE_FACTORY(Campaign);

#endif /* _CAMPAIGN_H */
