/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/


/**
   \brief breaks a string into parts that were initially seperated by comma
   \param string the string to break into substrings
*/

#include "substring.h"

SubString::SubString( char* string)
{
	n = 0;
	
	assert( string != NULL);
	
	for( int i = 0; i < strlen(string); i++) if( string[i] == ',') n++;

	n += 1;
	
	strings = malloc( sizeof( char*) * n);
	
	int i = 0;
	int l = 0;
	
	char* offset = string;
	char* end = strchr( string, ',');
	while( end != NULL)
	{
		l = end - offset;
		strings[i] = malloc( l + 1);
		strncpy( strings[i], offset, l);
		i++;
		end++;
		offset = end;
		end = strchr( string, ',');
	}
	
	strings[i] = malloc( l + 1);
	strncpy( strings[i], offset, l);
	l = strlen( offset);
}

/**
   \brief removes the object from memory
*/
SubString::~SubString()
{
	for( int i = 0; i < n; i++)
	{
		free( strings[i]);
	}
	
	free( strings);
}

/**
   \brief get the amount of substrings
   \returns the amount of substrings
*/
int SubString::getN()
{
	return n;
}

/**
   \brief get a particular substring
   \param i the ID of the substring to return
   \returns the designated substring or NULL if an invalid ID was given
*/
const char* SubString::getString( int i)
{
	if( i < n && i >= 0) return strings[i];
	else return NULL;
}