/*! 
    \file factory.h
    \brief philosophy stuff
*/

#ifndef _FACTORY_H
#define _FACTORY_H

#include "stdincl.h"
#include "world.h"

#define CREATE_FACTORY(CLASS) class CLASSFactory : public Factory { \
 public:	\
  CLASSFactory (){setNext( NULL); setClassname = "CLASS"; initialize();} \
  ~CLASSFactory (); \
 private: \
	BaseObject* fabricate( TiXmlElement* root) \
	{ \
		if(!strcmp(root->Value(), getClassname())) return new CLASS( root); \
		else if( next != NULL) return next->fabricate( root); \
		else return NULL; \
	} \
}; \
CLASSFactory global_CLASSFactory;

//! The Factory is
/**
	Very philosophic description, huh?
*/
class Factory {

 public:
  Factory ();
  ~Factory ();

	virtual BaseObject* fabricate( TiXmlElement* root);
	void initialize();
  void registerFactory( Factory* factory);
	void setClassname(char* name) {classname = name};
	char* getClassname() {return classname};
	void setNext( ObjectFactory* factory) {next = factory};
	
 private:
	char* classname;
	
  Factory* next;
};

// helper function

const char* grabParameter( TiXmlElement* root, const char* name);

#endif /* _FACTORY_H */

