

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Christian Meyer
   co-programmer: ...
*/


#include "factory.h"

using namespace std;

/*  --------------------------------------------------
*		 Factory
*   --------------------------------------------------
*/

/**
   \brief constructor
   
   set everything to zero and define classname
*/
Factory::Factory ()
{
	classname = "NULL"
	next = NULL;
}

/**
   \brief constructor
   
   clear the Q
*/
Factory::~Factory ()
{
	if( next != NULL)	delete next;
}


/**
   \brief generates the associated object from data
*/
BaseObject* ObjectFactory::fabricate( TiXmlElement* data)
{
	return NULL;
}

/**
   \brief make this particular factory known to the LevelFactory
*/
void Factory::initialize()
{
	GameLoader* gl = GameLoader::getInstance();
	gl->registerFactory( this);
}

/**
   \brief add a Factory to the Q
*/
void Factory::registerFactory( Factory* factory)
{
	if( next == NULL) setNext( factory);
	else next->registerFactory( factory);
}

const char* grabParameter( TiXmlElement* root, const char* name)
{
	TiXmlElement* element;
	TiXmlNode* node;
	
	assert( root != NULL);
	assert( name != NULL);
	
	element = root->FirstChildElement( name);
	if( element == NULL) return NULL;
	
	node = element->FirstChild();
	while( node != NULL)
	{
		if( node->Type() == TEXT) return node->Value();
		node = node->NextChild();
	}
	return NULL;
}

