/*! 
    \file world_entity.h
    \brief Definition of the basic WorldEntity
*/

#ifndef _WORLD_ENTITY_H
#define _WORLD_ENTITY_H

#include "stdincl.h"
#include "p_node.h"

//class CollisionCluster;
class OBJModel;

//! Basic class from which all interactive stuff in the world is derived from
class WorldEntity : public PNode
{	
  friend class World;

 public:
  WorldEntity (bool isFree = false);
  virtual ~WorldEntity ();

  OBJModel* model;                  //!< The model that should be loaded for this entity.
  
  //void setCollision (CollisionCluster* newhull);
  
  bool isFree ();
  
  //void addAbility(Ability* ability);
  //void removeAbility(Ability* ability);
  
  virtual void postSpawn ();
  virtual void tick (float time);
  virtual void hit (WorldEntity* weapon, Vector loc);
  virtual void destroy ();
  virtual void collide (WorldEntity* other,  Uint32 ownhitflags, Uint32 otherhitflags);
  virtual void command (Command* cmd);

  void processDraw ();
  virtual void draw ();
  void setDrawable (bool bDraw);
  
  virtual void leftWorld ();
  
 private:
  const bool bFree;	              //!< If the entity is free.
  bool bCollide;                      //!< If it should be considered for the collisiontest.
  bool bDraw;                         //!< If it should be visible.

  //CollisionCluster* collisioncluster; //!< The collision-Cluster of this entity.
};

#endif /* _WORLD_ENTITY_H */
