
/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: David Gruetter
   co-programmer: Benjamin Grauer
   
   Created by Dave: this file is actually quite similar to player.cc and so is 
   skybox.h similar to player.h
   With that said, things should be clear:)
   
   Edited:
   Bensch: more constructors, changeability, comments...
   Patrick: giving it the common orxonox style, not much to do... good work Dave!

*/

#include "material.h"
#include "skysphere.h"
#include "stdincl.h"
#include "vector.h"
#include "world_entity.h"


using namespace std;

/**
   \brief Standart Constructor
*/
Skysphere::Skysphere()
{  
  initialize("../data/pictures/sky-replace.jpg");
}

/**
   \brief Constructs a SkySphere and takes fileName as a map.
   \param fileName the file to take as input for the skysphere
*/
Skysphere::Skysphere(char* fileName)
{
  initialize(fileName);
}

/**
   \brief default destructor
*/
Skysphere::~Skysphere()
{
  PRINTF(3)("Deleting the SkySphere\n");
  delete skyMaterial;
  free(sphereObj);
}

/**
   \brief initializes the Skysphere.
   \param fileName the file to take as input for the skysphere
*/
void Skysphere::initialize(char* fileName)
{
  PRINTF(1)("initializing the Skysphere with Material %s.\n", fileName);
  this->sphereObj = gluNewQuadric();
  gluQuadricTexture(this->sphereObj, GL_TRUE);
  this->setRadius(250.0);

  this->skyMaterial = new Material("Sky");
  this->setTexture(fileName);
  this->skyMaterial->setIllum(3);
  this->skyMaterial->setAmbient(1.0, 1.0, 1.0);
}


/**
   \brief sets the Radius of the Sphere.
   \param radius The Radius of The Sphere
*/
void Skysphere::setRadius(float radius)
{
  this->sphereRadius = radius;
}


/**
   \brief Defines which texture should be loaded onto the skysphere.
   \param fileName The filename of the Texture
*/
void Skysphere::setTexture(char* fileName)
{
  this->skyMaterial->setDiffuseMap(fileName);
}


/**
   \brief updates the position of the Skysphere
   \param sphereCenter The coordinate of the Center of the Sphere
   
   This is normally done in the update-phase of world, so the Skysphere is always centered at the Camera.
*/
void Skysphere::updatePosition(Vector sphereCenter)
{
  this->sphereCenter = sphereCenter;
}


/**
   \brief draws the Skysphere
   
   This part is normally precessed in the "Painting Phase".
*/
void Skysphere::draw()
{
  glEnable(GL_TEXTURE_2D);
  skyMaterial->select();
  glPushMatrix();
  glTranslatef(this->sphereCenter.x,this->sphereCenter.y,this->sphereCenter.z);
  
  glRotatef(-30, 1, 0, 0);
  glRotatef(95.0f, 0.0f, 0.0f, 1.0f);
  glRotatef(-250.0f, 0.0, 1.0f, 0.0f);
  
  gluSphere(sphereObj, sphereRadius, 20, 20);
  glPopMatrix();
  glDisable(GL_TEXTURE_2D);
}
