

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:  Benjamin Grauer
*/


#include <iostream>
#include <math.h>
#include <GL/glut.h>

#include "stdincl.h"
#include "data_tank.h"
#include "npc.h"

#include "shoot_rocket.h"

using namespace std;



ShootRocket::ShootRocket ()
{
  lastShoot = null;
  step = 1.0;
  inhibitor =0;
  rotateAngle = 0.0;
}


ShootRocket::~ShootRocket () {}


void ShootRocket::drawShoot() 
{

  //cout << "ShootRocket::drawShoot" << endl;
  /* now draw all the shoots (many) */
  shoot* tmpShoot = lastShoot;
  shoot* lastRef = null;
  while( tmpShoot != null )
    {
      glPushMatrix(); 
      glTranslatef(tmpShoot->xCor, tmpShoot->yCor, tmpShoot->zCor);
      tmpShoot->age+=step;
      switch (tmpShoot->type)
	{
	case BACKPARABLE:
	  tmpShoot->xCor+=tmpShoot->xVel;
	  tmpShoot->yCor+=tmpShoot->yVel;
	  tmpShoot->xVel+=tmpShoot->xAcc;
	  tmpShoot->yVel+=tmpShoot->yAcc;
	  break;
	
	case SIDEACC:
	  if (tmpShoot->xVel >= .01 || tmpShoot->xVel <= -.01)
	    {
	      tmpShoot->xCor+=tmpShoot->xVel;
	      tmpShoot->yCor+=tmpShoot->yVel;
	      tmpShoot->xVel*=tmpShoot->xAcc;
	    }
	  else
	    {
	      tmpShoot->xCor+=tmpShoot->xVel;
	      tmpShoot->yCor+=tmpShoot->yVel;
	      tmpShoot->yVel+=tmpShoot->yVel*tmpShoot->yAcc;
	    }
	  break;
	
	case ROTATER:
	  tmpShoot->xCor+=tmpShoot->xVel;
	  tmpShoot->yCor+=tmpShoot->yVel;
	  tmpShoot->zCor+=tmpShoot->zVel;
	  break;
	
	}
      
      glScalef(0.1, 0.1, 0.1);
      glutWireCube(1.0);
      glPopMatrix();

      /* garbage collection: look if shoot is outside world */
      /* fix1: weak boundaries check all four sides */
      /* fix2: conditions, that a struct tree can be cut off */
      /* fix3: more efficent and nicer please */
      if (tmpShoot->age > tmpShoot->lifetime) 
	{
	  /* normal case: delete one element, link the others */
	  if (lastRef != null) 
	    {
	      //cout << "garbage collection" << endl;
	      lastRef->next = tmpShoot->next;
	      delete tmpShoot;
	      tmpShoot = lastRef->next;
	      //cout << "garbage collection left" << endl;
	    }
	  else
	    {
	      /* special case: first element to be processed */
	      //cout << "garbage collecton: first el in queue" << endl;
	      lastRef = tmpShoot->next;
	      delete tmpShoot;
	      tmpShoot = lastRef;
	      lastShoot = tmpShoot;
	      if (tmpShoot != null) 
		{
		  tmpShoot = tmpShoot->next;
		  //cout << "noch nich null" << endl;
		}
	      else 
		{
		  lastRef = null;
		  tmpShoot = null;
		  lastShoot = null;
		  //cout << "endl null" << endl;
		}
	      
	      //cout << "garbage collection: firtst el in queue left" << endl;
	    }
	}
      else 
	{
	  lastRef = tmpShoot;
	  tmpShoot = tmpShoot->next;
	}
    }
  //cout << "ShootRocket::drawShoot - finished" << endl;
}


void ShootRocket::addShoot(shoot* sh) 
{
  sh->next = null;
  lastShoot = sh;
}

void ShootRocket::addBackParable(float x, float y, float z)
{
  
  //cout << "ShootRocket::addShoot" << endl;
  shoot* sh = new shoot;
  sh->type = BACKPARABLE;
  sh->xCor = x; sh->yCor = y; sh->zCor = z;
  sh->xVel = (-1+(float)rand() / 1000000000/step)/5; 
  sh->yVel = -.3;
  sh->zVel = (1-(float)rand() / 1000000000/step)/5;
  sh->xAcc = 0; sh->yAcc = .01/step; sh->zAcc = 0;
  sh->age=0;
  sh->lifetime=5; 
  sh->next = lastShoot;
  lastShoot = sh;
  }
void ShootRocket::addSideAcc(float x, float y, float z, enum RocketDirection direction)
{
  //cout << "ShootRocket::addShoot" << endl;
  shoot* sh = new shoot;
  sh->type = SIDEACC;
  sh->xCor = x; sh->yCor = y; sh->zCor = z;
  switch (direction)
    {
    case LEFT:
      sh->xVel = -.5; sh->yVel = .05; sh->zVel = 0;
      break;
    case RIGHT:
      sh->xVel = .5; sh->yVel = .05; sh->zVel = 0;
      break;
    }
  sh->xAcc = .9; sh->yAcc = .02; sh->zAcc = 0;
  sh->age=0;
  sh->lifetime=10; 
  sh->next = lastShoot;
  lastShoot = sh;
}

void ShootRocket::addRotater(float x, float y, float z)
{
  
  static float radius = 2;
  rotateAngle+=.1;
  //cout << "ShootRocket::addShoot" << endl;
  shoot* sh = new shoot;
  sh->type = ROTATER;
  sh->xCor = x+radius*sin(rotateAngle); sh->yCor = y; sh->zCor = z+radius*cos(rotateAngle);
  sh->xVel = 1*cos(rotateAngle)*step;
  sh->yVel = 4*step;
  sh->zVel = 1*sin(rotateAngle)*step;
  sh->xAcc = 1.01; sh->yAcc = 1- step; sh->zAcc = 1.01;
  sh->age=0;
  sh->lifetime=10; 
  sh->next = lastShoot;
  lastShoot = sh;
}

void ShootRocket::setShootStep(float step) 
{
  cout << "ShootRocket::setShootStep to " << step << endl;
  this->step = step;
}


/* Exterminate shoot from game, implement this method  */
/* if you like to add animatiion */
void ShootRocket::removeShoot(shoot* sh)
{
  glPushMatrix(); 
  glTranslatef(sh->xCor, sh->yCor, sh->zCor);
  glutWireCube(1.0);
  glPopMatrix();
}
