

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: 
*/




#include <GL/glut.h>
#include <iostream>

#include "stdincl.h"
#include "data_tank.h"

#include "shoot_laser.h"

using namespace std;



ShootLaser::ShootLaser () 
{
  lastShoot = null;
  step = 1.0;
  inhibitor = 0;
}


ShootLaser::~ShootLaser () {}


void ShootLaser::drawShoot() 
{

  //cout << "ShootLaser::drawShoot" << endl;
  /* now draw all the shoots (many) */
  shoot* tmpShoot = lastShoot;
  shoot* lastRef = null;
  while( tmpShoot != null )
    {
      glPushMatrix(); 
      glTranslatef(tmpShoot->xCor, tmpShoot->yCor, tmpShoot->zCor);
      tmpShoot->xCor+=tmpShoot->xVel;
      tmpShoot->yCor+=tmpShoot->yVel;
      glScalef(0.1, 0.1, 0.1);
      glutWireCube(1.0);
      glPopMatrix();

      /* garbage collection: look if shoot is outside world */
      /* fix1: weak boundaries check all four sides */
      /* fix2: conditions, that a struct tree can be cut off */
      /* fix3: more efficent and nicer please */
      if (tmpShoot->yCor - DataTank::yOffset > 20) 
	{
	  /* normal case: delete one element, link the others */
	  if (lastRef != null) 
	    {
	      //cout << "garbage collection" << endl;
	      lastRef->next = tmpShoot->next;
	      delete tmpShoot;
	      tmpShoot = lastRef->next;
	      //cout << "garbage collection left" << endl;
	    }
	  else
	    {
	      /* special case: first element to be processed */
	      //cout << "garbage collecton: first el in queue" << endl;
	      lastRef = tmpShoot->next;
	      delete tmpShoot;
	      tmpShoot = lastRef;
	      lastShoot = tmpShoot;
	      if (tmpShoot != null) 
		{
		  tmpShoot = tmpShoot->next;
		  //cout << "noch nich null" << endl;
		}
	      else 
		{
		  lastRef = null;
		  tmpShoot = null;
		  lastShoot = null;
		  //cout << "endl null" << endl;
		}
	      
	      //cout << "garbage collection: firtst el in queue left" << endl;
	    }
	}
      else 
	{
	  lastRef = tmpShoot;
	  tmpShoot = tmpShoot->next;
	}
    }
  //cout << "ShootLaser::drawShoot - finished" << endl;
}


void ShootLaser::addShoot(shoot* sh) 
{
  sh->next = null;
  lastShoot = sh;
}

void ShootLaser::addShoot(float x, float y, float z)
{
  //cout << "ShootLaser::addShoot" << endl;
  shoot* sh = new shoot;
  sh->xCor = x; sh->yCor = y; sh->zCor = z;
  sh->xVel = 0; sh->yVel = .4/step; sh->zVel = 0;
  sh->next = lastShoot;
  lastShoot = sh;
}

void ShootLaser::addShootExt(float x, float y, float z, 
			     float xVel, float yVel, float zVel)
{
  //cout << "ShootLaser::addShootExtended" << endl;
  shoot* sh = new shoot;
  sh->xCor = x; sh->yCor = y; sh->zCor = z;
  sh->xVel = xVel/step; sh->yVel = yVel/step; sh->zVel = zVel/step;
  sh->next = lastShoot;
  lastShoot = sh;
}

void ShootLaser::setShootStep(float step) 
{
  cout << "ShootLaser::setShootStep to " << step << endl;
  this->step = step;
  cout << "ShootLaser::setShootStep end " << step << endl;
}


/* Exterminate shoot from game, implement this method  */
/* if you like to add animatiion */
void ShootLaser::removeShoot(shoot* sh)
{
  glPushMatrix(); 
  glTranslatef(sh->xCor, sh->yCor, sh->zCor);
  glutWireCube(1.0);
  glPopMatrix();
}
