/*! 
    \file story_entity.h
    \brief holds the base class of everything that is playable - that is part of the story
*/ 


#ifndef _STORY_ENTITY_H
#define _STORY_ENTITY_H

#include "stdincl.h"
#include "story_def.h"

//! A class that represents something to play in orxonox. it is a container for worlds, movies, mission briefings, etc...
class StoryEntity : public BaseObject {

 public:
  StoryEntity ();
  virtual ~StoryEntity ();

  bool isInit;  //! if the entity is initialized, this has to be true
  bool isPaused; //! is true if the entity is paused

  virtual ErrorMessage load();
  virtual ErrorMessage init();
  virtual ErrorMessage start(int storyID);
  virtual ErrorMessage start();
  virtual ErrorMessage pause();
  virtual ErrorMessage resume();
  virtual ErrorMessage stop();
  virtual ErrorMessage destroy();


  virtual void displayLoadScreen();
  virtual void releaseLoadScreen();

  void setStoryID(int storyID);
  int getStoryID();

  void setNextStoryID(int nextStoryID);
  int getNextStoryID();


 private:
  int storyID; //! this is the number of this entity, identifying it in a list/tree...
  int nextStoryID; //! if this entity has finished, this entity shall be called
};

#endif /* _STORY_ENTITY_H */
