
#ifndef _LIST_H
#define _LIST_H

#include "stdincl.h"

//! An enum to list all the modes available when adding an object to a List
//enum ADDMODE {LIST_ADD_FIRST, LIST_ADD_LAST};
//! An enum to list the two searching directions available when removing an object from a List
//enum FINDMODE {LIST_FIND_BW, LIST_FIND_FW};



class WorldEntity;

class List {

 public:
  List ();
  ~List ();

  void add(WorldEntity* entity);
  void remove(WorldEntity* entity);
  void destroy();
  WorldEntity* firstElement();
  bool isEmpty();
  int getSize();
  WorldEntity* enumerate();
  WorldEntity* nextElement();
  WorldEntity* toArray();
  void debug();

 private:
  struct listElement
  {
    listElement* prev;
    WorldEntity* curr;
    listElement* next;
  };
  Uint32 size;
  listElement* first;
  listElement* last;
  listElement* currentEl;


};

class Iterator
{

 public:
  bool hasNext();
  WorldEntity* next();

 private:

};


template<class T> class tList 
{
 private:
  struct listElement
  {
    listElement* prev;
    T* curr;
    listElement* next;
  };

  Uint32 size;
  listElement* first;
  listElement* last;
  listElement* currentEl;
  
 public:
  tList ();
  ~tList ();
  

  void add(T* entity);
  void remove(T* entity);
  void destroy();
  T* firstElement();
  bool isEmpty();
  int getSize();
  T* enumerate();
  T* nextElement();
  T* toArray();
  void debug();
};


template<class T>
tList<T>::tList () 
{
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}

template<class T>
tList<T>::~tList () 
{}

template<class T>
void tList<T>::add(T* entity)
{
  listElement* el = new listElement;
  el->prev = this->last;
  el->curr = entity;
  el->next = NULL;

  this->last = el;

  if(this->size == 0) this->first = el;
  else el->prev->next = el;
  this->size++;
}


template<class T>
void tList<T>::remove(T* entity)
{
  this->currentEl = this->first;
  listElement* te;
  while( this->currentEl != NULL)
    {
      if( this->currentEl->curr == entity)
	{ 
	  if( this->currentEl->prev  == NULL ) this->first = this->currentEl->next;
	  else this->currentEl->prev->next = this->currentEl->next;

	  if( this->currentEl->next == NULL) this->last = this->currentEl->prev;
	  else this->currentEl->next->prev = this->currentEl->prev;

	  te = this->currentEl->next;
	  delete this->currentEl;
	  this->currentEl = te;
	  return;
	}
      this->currentEl = this->currentEl->next;
    }
}


template<class T>
void tList<T>::destroy()
{
  this->currentEl = this->first;
  while(this->currentEl != NULL)
    {
      listElement* le = this->currentEl->next;
      delete this->currentEl->curr;
      delete this->currentEl;
      this->currentEl = le;
    }
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}


template<class T>
T* tList<T>::firstElement()
{
  return this->first->curr;
}


template<class T>
bool tList<T>::isEmpty()
{
  return (this->size==0)?true:false;
}


template<class T>
int tList<T>::getSize()
{
  return this->size;
}


template<class T>
T* tList<T>::enumerate()
{
  if(this->size == 0) return NULL;
  this->currentEl = this->first;
  return this->currentEl->curr;
}


template<class T>
T* tList<T>::nextElement()
{
  if(this->size == 0) return NULL;
  this->currentEl = this->currentEl->next;
  if(this->currentEl == NULL) return NULL;
  return this->currentEl->curr;
}


template<class T>
T* tList<T>::toArray()
{}

#endif /* _LIST_H */
