

/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


#include "list.h"
#include "world_entity.h"

using namespace std;



List::List () 
{
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}

List::~List () 
{}


void List::add(WorldEntity* entity)
{
  printf("List::add() \n");
  listElement* el = new listElement;
  el->prev = this->last;
  el->curr = entity;
  el->next = NULL;

  this->last = el;

  if(this->size == 0) this->first = el;
  else el->prev->next = el;
  this->size++;
}


void List::remove(WorldEntity* entity)
{
  this->currentEl = this->first;
  listElement* te;
  while( this->currentEl != NULL)
    {
      if( this->currentEl->curr == entity)
	{
	  printf("List::remove() - object found\n");
	  
	  if( this->currentEl->prev  == NULL ) this->first = this->currentEl->next;
	  else this->currentEl->prev->next = this->currentEl->next;

	  if( this->currentEl->next == NULL) this->last = this->currentEl->prev;
	  else this->currentEl->next->prev = this->currentEl->prev;

	  te = this->currentEl->next;
	  delete this->currentEl;
	  this->currentEl = te;
	  return;
	}
      this->currentEl = this->currentEl->next;
    }
}


void List::destroy()
{
  printf("List::clear() - clearing all world objects, releasing mem\n");
  this->currentEl = this->first;
  listElement* le = NULL;
  while(this->currentEl != NULL)
    {
      le = this->currentEl->next;
      delete this->currentEl->curr;
      delete this->currentEl;
      this->currentEl = le;
    }
  this->first = NULL;
  this->last = NULL;
  this->size = 0;
}


WorldEntity* List::firstElement()
{
  return this->first->curr;
}


bool List::isEmpty()
{
  return (this->size==0)?true:false;
}


int List::getSize()
{
  return this->size;
}


WorldEntity* List::enumerate()
{
  if(this->size == 0) return NULL;
  this->currentEl = this->first;
  return this->currentEl->curr;
}


WorldEntity* List::nextElement()
{
  if(this->size == 0) return NULL;
  this->currentEl = this->currentEl->next;
  if(this->currentEl == NULL) return NULL;
  return this->currentEl->curr;
}


WorldEntity* List::toArray()
{}


void List::debug()
{
  int counter = 1;
  this->currentEl = this->first;
  printf("List:debug() =====================\n");
  while(this->currentEl != NULL)
    {
      printf("element: nr %d/%d\n", counter, size);
      this->currentEl = this->currentEl->next;
      counter++;
    }
  printf("List:debug()END =====================\n");
}
