/*!
    \file ini_parser.h
    \brief A small ini file parser
    
    Can be used to find a defined [Section] in an ini file and get the VarName=Value entries
*/

#ifndef _INI_PARSER_H
#define _INI_PARSER_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define PARSELINELENGHT 512

//! ini-file parser
/**
	This class can be used to load an initializer file and parse it's contents for variablename=value pairs.
*/
class IniParser {
 private:
	FILE* stream;
	bool bInSection;
	char internbuf[PARSELINELENGHT];
	
 public:
  IniParser (char* filename);
  ~IniParser ();
  
  char* getVar( char* name, char* section, char* defvalue);
	int openFile( char* name);
  int getSection( char* section);
  int nextVar( char* name, char* value);
};

#endif /* _INI_PARSER_H */
