#ifndef _MATRIX_H
#define _MATRIX_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <iostream>

using namespace std;

class Matrix
{
public:
  // Constructors
  Matrix (const Matrix& m);
  Matrix (size_t row, size_t col);
  
  // Destructor
  ~Matrix ();
  
  // Assignment operators
  Matrix& operator = (const Matrix& m) ;
  
  // Value extraction method
  size_t RowNo () const { return _m->Row; }
  size_t ColNo () const { return _m->Col; }
  
  // Subscript operator
  float& operator () (size_t row, size_t col);
   float  operator () (size_t row, size_t col) const;

   // Unary operators
   Matrix operator + ()  { return *this; }
   Matrix operator - () ;

   // Combined assignment - calculation operators
   Matrix& operator += (const Matrix& m);
   Matrix& operator -= (const Matrix& m);
   Matrix& operator *= (const Matrix& m);
   Matrix& operator *= (const float& c) ;
   Matrix& operator /= (const float& c) ;
   Matrix& operator ^= (const size_t& pow);

   // Miscellaneous -methods
   void Null (const size_t& row, const size_t& col) ;
   void Null () ;
   void Unit (const size_t& row) ;
   void Unit () ;
   void SetSize (size_t row, size_t col) ;

   // Utility methods
   Matrix Solve (const Matrix& v) const;
   Matrix Adj ();
   Matrix Inv ();
   float Det () const;
   float Norm () ;
   float Cofact (size_t row, size_t col);
   float Cond () ;

   // Type of matrices
   bool IsSquare ()  { return (_m->Row == _m->Col); } 
   bool IsSingular ();
   bool IsDiagonal ();
   bool IsScalar ();
   bool IsUnit ();
   bool IsNull ();
   bool IsSymmetric ();
   bool IsSkewSymmetric ();
   bool IsUpperTriangular ();
   bool IsLowerTriangular ();

private:
   struct base_mat
    {
	float **Val;
	size_t Row, Col, RowSiz, ColSiz;
	int Refcnt;

	base_mat (size_t row, size_t col, float** v)
	{
	    Row = row; RowSiz = row;
	    Col = col; ColSiz = col;
	    Refcnt = 1;

	    Val = new float* [row];
	    size_t rowlen = col * sizeof(float);

	    for (size_t i=0; i < row; i++)
	    {
		Val[i] = new float [col];
		if (v) memcpy( Val[i], v[i], rowlen);
	    }
	}
	~base_mat ()
	{
	    for (size_t i=0; i < RowSiz; i++)
		delete [] Val[i];
	    delete [] Val;
	}
    };
    base_mat *_m;

    void clone ();
    void realloc (size_t row, size_t col);
    int pivot (size_t row);
};

Matrix operator ! (const Matrix m);

#endif /*_MATRIX_H */
