/* 
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


   ### File Specific:
   main-programmer: Benjamin Grauer

*/

#include "orxonox_gui_audio.h"

/**
   \brief Creates an Audio-Frame
*/
OrxonoxGuiAudio::OrxonoxGuiAudio(void)
{
  this->audioFrame = new Frame("Audio-Options:");
  this->audioBox = new Box('v');
  this->audioFrame->setGroupName("audio");
  
  this->enableSound = new CheckButton("Disable Sound");
  this->enableSound->setFlagName ("no-sound", 0);
  this->enableSound->saveability();
  this->audioBox->fill(this->enableSound);
  Label* musicVolumeLabel = new Label("Music Volume");
  this->audioBox->fill(musicVolumeLabel);
  this->musicVolume = new Slider("Music Volume", 0, 100);
  this->musicVolume->setFlagName("music-volume", "m", 80);
  this->musicVolume->saveability();
  this->audioBox->fill (this->musicVolume);
  Label* effectsVolumeLabel = new Label ("Effects Volume");
  this->audioBox->fill (effectsVolumeLabel);
  this->effectsVolume = new Slider ("Effects Volume", 0, 100);
  this->effectsVolume->setFlagName ("effects-volume", "e", 80);
  this->effectsVolume->saveability();
  this->audioBox->fill (this->effectsVolume);

  this->audioFrame->fill (this->audioBox);
}

/** 
    \brief Destructs the Audio-Stuff
*/
OrxonoxGuiAudio::~OrxonoxGuiAudio(void)
{
  // nothing to do here.
}

/**
   \brief Return the Frame
   \return Returns the Audio-frame
*/
Widget* OrxonoxGuiAudio::getWidget(void)
{
  return this->audioFrame;
}
